<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Admin\MainWallet;
use App\Models\Admin\Website;
use App\Models\User;
use App\Models\Admin\UserMessage;
use App\Models\Withdraw;
use Illuminate\Http\Request;

class WithdrawController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas = Withdraw::latest()->get();
        $website = Website::latest()->first();
        $title = 'Withdraw Request';
        return view('backend.pages.system-setting.withdraw', compact('title', 'datas', 'website'));
    }

    public function pending_withdraw_request()
    {
        $datas = Withdraw::where('approval', 0)->latest()->get();
        $website = Website::latest()->first();
        $title = 'Pending Withdraw Request';
        return view('backend.pages.system-setting.withdraw', compact('title', 'datas', 'website'));
    }

    public function withdraw_request_approved(Request $request, $id)
{
    $withdraw = Withdraw::find($id);
    $msg_user_id = $withdraw->user_id;

    if ($request->approval == 1) {
        $payable = $withdraw->amount - $withdraw->charge;

        $main_wallet = MainWallet::latest()->first();
        $main_wallet->amount = $main_wallet->amount - $payable;
        $main_wallet->save();
    } elseif ($request->approval == 2) {
        $user = User::find($withdraw->user_id);
        $user->earning_balance = $user->earning_balance + $withdraw->amount;
        $user->save();
    }

    $withdraw->approval = $request->approval;
$withdraw->reason = $request->reason;
$withdraw->save();

$data = new UserMessage();
$data->user_id = $msg_user_id;

if ($request->approval == 1) {
    $data->message_title = 'WITHDRAW_APPROVED';
    $data->message = 'Your Withdraw Approved & Must Be Share Your Feedback In Social Media.';
} else {
    $data->message_title = 'WITHDRAW_REJECTED';
    $data->message = 'Your Withdraw Rejected. Reason: ' . $request->reason;
}

$data->save();


    return redirect()->back()->with('message', 'Successfully ' . ($request->approval == 1 ? 'approved' : 'rejected') . ' this withdrawal!');
}


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $withdraw = Withdraw::find($id);
        $withdraw->delete();

        return redirect()->back()->with('message','Successfully deleted this withdraw request!');
    }
}
